/*

Macro Scripts File
Created:   13 Sept 2010: Max 2012
Author:   Stephen Taylor

MacroScripts for the new MassFX physics system

*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK


-- Rigid Bodies
MacroScript PxSetSelAsDynRigidBodyMS
ButtonText:~PXSETSELASDYNRIGIDBODY_BUTTONTEXT~
Tooltip:~PXSETSELASDYNRIGIDBODY_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",2)
(
	on isEnabled  do (currentNode = PxGetCurrentNode(); return currentNode !=undefined)
	On Execute Do (	PxCreateAsDynamic() )
)

MacroScript PxSetSelAsKinRigidBodyMS
ButtonText:~PXSETSELASKINEMATICRIGIDBODY_BUTTONTEXT~
Tooltip:~PXSETSELASKINEMATICRIGIDBODY_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",3)
(
	on isEnabled  do (currentNode = PxGetCurrentNode(); return currentNode !=undefined)
	On Execute Do (	PxCreateAsKinetic() )
)

MacroScript PxSetSelAsStaticRigidBodyMS
ButtonText:~PXSETSELASSTATICRIGIDBODY_BUTTONTEXT~
Tooltip:~PXSETSELASSTATICRIGIDBODY_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",4)
(
	on isEnabled  do (currentNode = PxGetCurrentNode(); return currentNode !=undefined)
	On Execute Do (	PxCreateAsStatic() )
)

MacroScript PxCreateDynamicSkeletonMS
ButtonText:~PXCREATEDYNAMICSKELETON_BUTTONTEXT~
Tooltip:~PXCREATEDYNAMICSKELETON_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",16)
(
		on isEnabled  do 
		(
			currentNode = PxGetCurrentNode()			
			return currentNode !=undefined and PxPotentialRagdollHelper(currentNode)
		)
	On Execute Do (	PxCreateDynamicRagdollHelper() )
)

MacroScript PxCreateKinematicSkeletonMS
ButtonText:~PXCREATEKINEMATICSKELETON_BUTTONTEXT~
Tooltip:~PXCREATEKINEMATICSKELETON_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",17)
(
		on isEnabled  do 
		(
			currentNode = PxGetCurrentNode()			
			return currentNode !=undefined and PxPotentialRagdollHelper(currentNode)
		)
	On Execute Do (	PxCreateKinematicRagdollHelper() )
)

MacroScript PxRemoveSkeletonMS
ButtonText:~PXREMOVERAGDOLL_BUTTONTEXT~
Tooltip:~PXREMOVERAGDOLL_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",18)
(
	On Execute Do (	PxRemoveRagdollHelper()	)
)


-- Constraints
MacroScript PxCreateRigidConstraintMS
ButtonText:~PXCREATERIGIDCONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATERIGIDCONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",9)
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintRigidMode))
	On Execute Do (	PxCreateConstrintRigid() )
)

MacroScript PxCreateSlideConstraintMS
ButtonText:~PXCREATESLIDECONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATESLIDECONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",10)
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintSlideMode))
	On Execute Do (	PxCreateConstrintSlide() )
)

MacroScript PxCreateHingeConstraintMS
ButtonText:~PXCREATEHINGECONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATEHINGECONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",11)
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintHingeMode))
	On Execute Do (	PxCreateConstrintHinge() )
)

MacroScript PxCreateTwistConstraintMS
ButtonText:~PXCREATETWISTCONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATETWISTCONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",12)
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintTwistMode))
	On Execute Do (	PxCreateConstrintTwist() )
)

MacroScript PxCreateBallAndSocketConstraintMS
ButtonText:~PXCREATEBALLANDSOCKETCONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATEBALLANDSOCKETCONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",14)
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintBallSocketMode))
	On Execute Do (	PxCreateConstrintBallSocket() )
)

MacroScript PxCreateUniversalConstraintMS
ButtonText:~PXCREATEUNIVERSALCONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATEUNIVERSALCONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",13)
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintUnivMode))
	On Execute Do (	PxCreateConstrintUniv() )
)

MacroScript PxRemoveConstraintMS
ButtonText:~PXREMOVECONST_BUTTONTEXT~
Tooltip:~PXREMOVECONST_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	on IsEnabled do ( gPxCreateConstraintTypeFlag != 0)
	On Execute Do (	PxCreateAs PX_PHYSTYPE_UNDEFINED )
)


-- MassFX Cloth

MacroScript PxCreateClothMS
ButtonText:~PXCREATECLOTH_BUTTONTEXT~
Tooltip:~PXCREATECLOTH_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",24)
(
	On Execute Do (	PxCreateAsCloth() )
)

MacroScript PxRemoveClothMS
ButtonText:~PXREMOVECLOTH_BUTTONTEXT~
Tooltip:~PXREMOVECLOTH_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	PxRemoveCloth() )
)



-- Simulation
MacroScript PxPlaySimMS
ButtonText:~PXPLAYSIM_BUTTONTEXT~
Tooltip:~PXPLAYSIM_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",6)
(
	on isChecked do
	(
		return PxIsSimulationRunning() and nvpx.GetAnimationState()
	)
	on execute do
	(
		-- Set simulation type (with or without animation) if command will start simulation
		if not PxIsSimulationRunning() do nvpx.SetAnimationState(true)

		PxRunSimulation() -- Start or stop simulation
	)
)

macroScript PxPlaySimWithoutAnimMS
ButtonText:~PXPLAYSIMWITHOUTANIM_BUTTONTEXT~
Tooltip:~PXPLAYSIMWITHOUTANIM_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",7)
(
	on isChecked do
	(
		return PxIsSimulationRunning() and not nvpx.GetAnimationState()
	)
	on execute do
	(
		-- Set simulation type (with or without animation) if command will start simulation
		if not PxIsSimulationRunning() do nvpx.SetAnimationState(false)

		PxRunSimulation() -- Start or stop simulation
	)
)

MacroScript PxStepSimMS
ButtonText:~PXSTEPSIM_BUTTONTEXT~
Tooltip:~PXSTEPSIM_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",8)
(
	On Execute Do (	PxStepSimulation() )
)

MacroScript PxResetSimMS
ButtonText:~PXRESETSIM_BUTTONTEXT~
Tooltip:~PXRESETSIM_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",5)
(
	On Execute Do (	PxStopSimulation() )
)


-- Baking
MacroScript PxBakeAllMS
ButtonText:~PXBAKEALL_BUTTONTEXT~
Tooltip:~PXBAKEALL_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	pxBakeAll false )
)

MacroScript PxBakeSelMS
ButtonText:~PXBAKESEL_BUTTONTEXT~
Tooltip:~PXBAKESEL_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	on IsEnabled do ( selection.count != 0 )
	On Execute Do (	pxBakeSelection false )
)

MacroScript PxUnBakeAllMS
ButtonText:~PXUNBAKEALL_BUTTONTEXT~
Tooltip:~PXUNBAKEALL_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	pxBakeAll true )
)

MacroScript PxUnBakeSelMS
ButtonText:~PXUNBAKESEL_BUTTONTEXT~
Tooltip:~PXUNBAKESEL_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	on IsEnabled do ( selection.count != 0 )
	On Execute Do (	pxBakeSelection true )
)


-- Utilities
MacroScript PxValidateSceneMS
ButtonText:~PXVALIDATESCENE_BUTTONTEXT~
Tooltip:~PXVALIDATESCENE_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	nvpx.ShowValidateScene false)
)

MacroScript PxExportSceneMS
ButtonText:~PXEXPORTSCENE_BUTTONTEXT~
Tooltip:~PXEXPORTSCENE_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	 PxExportPxProj_Prompting false )
)

MacroScript PxCaptureCurrXFormMS
ButtonText:~PXCAPTURECURRXFORM_BUTTONTEXT~
Tooltip:~PXCAPTURECURRXFORM_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do ( PxCaptureTransform(false) )
)

MacroScript PxAboutBoxMS
ButtonText:~PXABOUT_BUTTONTEXT~
Tooltip:~PXABOUT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	PxShowAbout() )
)

MacroScript PxShowToolsWindowMS
ButtonText:~PXSHOWTOOLSWINDOW_BUTTONTEXT~
Tooltip:~PXSHOWTOOLSWINDOW_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",1)
(
	On isChecked do ( px_physXPanel.open )
	On Execute Do 
	(	
		if (px_physXPanel.open) then (
			PxPanelClose()
		)
		else (
			PxShowPhysicsPanel(1)
		)
	)
	On closeDialogs do ( PxPanelClose() ) 
)

MacroScript PxShowToolsWindowWorldMS
ButtonText:~PXSHOWTOOLSWINDOWWORLD_BUTTONTEXT~
Tooltip:~PXSHOWTOOLSWINDOWWORLD_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",1)
(
	On isChecked do ( px_physXPanel.open )
	On Execute Do 
	(	
		if (px_physXPanel.open) and (px_physXPanel.GetCurrentPage()==1) then (
			PxPanelClose()
		)
		else (
			PxShowPhysicsPanel(1)
		)
	)
	On closeDialogs do ( PxPanelClose() ) 
)

MacroScript PxShowToolsWindowToolsMS
ButtonText:~PXSHOWTOOLSWINDOWTOOLS_BUTTONTEXT~
Tooltip:~PXSHOWTOOLSWINDOWTOOLS_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",28)
(
	On isChecked do ( px_physXPanel.open )
	On Execute Do 
	(	
		if (px_physXPanel.open) and (px_physXPanel.GetCurrentPage()==2) then (
			PxPanelClose()
		)
		else (
			PxShowPhysicsPanel(2)
		)
	)
	On closeDialogs do ( PxPanelClose() ) 
)

MacroScript PxShowToolsWindowMultiEditMS
ButtonText:~PXSHOWTOOLSWINDOWMULTIEDIT_BUTTONTEXT~
Tooltip:~PXSHOWTOOLSWINDOWMULTIEDIT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",30)
(
	On isChecked do ( px_physXPanel.open )
	On Execute Do 
	(	
		if (px_physXPanel.open) and (px_physXPanel.GetCurrentPage()==3) then (
			PxPanelClose()
		)
		else (
			PxShowPhysicsPanel(3)
		)
	)
	On closeDialogs do ( PxPanelClose() ) 
)

MacroScript PxShowToolsWindowDisplayMS
ButtonText:~PXSHOWTOOLSWINDOWDISPLAY_BUTTONTEXT~
Tooltip:~PXSHOWTOOLSWINDOWDISPLAY_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",29)
(
	On isChecked do ( px_physXPanel.open )
	On Execute Do 
	(	
		if (px_physXPanel.open) and (px_physXPanel.GetCurrentPage()==4) then (
			PxPanelClose()
		)
		else (
			PxShowPhysicsPanel(4)
		)
	)
	On closeDialogs do ( PxPanelClose() ) 
)

macroScript OpenDynamicsExplorer 
ButtonText:~OPENDYNAMICSEXPLORER_BUTTONTEXT~
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
tooltip:~OPENDYNAMICSEXPLORER_TOOLTIP~ 
-- No icon yet
(
	on isEnabled return true
	on isChecked return false
	on isVisible return true
	on execute do
	(
		-- If the dynamics explorer has not been loaded yet, do it now.
		-- We rely on the explorer name "MassFX Explorer"/"Dynamics Explorer" as defined in the 
		-- InstanceName field of the "DefaultDynamicsExplorer.ini" file.
		if not SceneExplorerManager.ExplorerExists ~DYNAMICSEXPLORER_CAPTION~ then
		(
			local cfgpath = pathConfig.GetDir #plugcfg
			cfgpath = pathConfig.appendPath cfgpath "ExplorerConfig\SceneExplorer"
			local cfgfile = pathConfig.appendPath cfgpath "DefaultDynamicsExplorer.ini"
			SceneExplorerManager.LoadExplorerConfiguration cfgfile
		)
		SceneExplorerManager.OpenExplorer ~DYNAMICSEXPLORER_TITLE~
	)
)

